import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedList;


public class MyCanvas extends Canvas implements MouseListener, Runnable {
	
	private App a;
	private Dimension d = this.getSize();
	private int w,h;
	
	public MyCanvas(App a) {
		super();
		this.a = a;
		addMouseListener(this);
	}
	
	public void setApp(App a) {
		this.a = a;
	}
	
	// Mouse Event handlers
	public void mouseClicked(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {
		int clickedX = e.getX();
		int clickedY = e.getY();
		
		int ladung = a.getColoumbValue();
		
		Ladung l = new Ladung(ladung,a.isPositiv,clickedX,clickedY);
		a.ladungen.add(l);
		
		
		repaint();
	}
	
	public void run() {
		while(true) {
			if(a.isSimulationActive()) {
				try {
					Thread.sleep(200);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					//e.printStackTrace();
				}
			}
			else {
				try {
					wait();
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					//e.printStackTrace();
				}
			}
			repaint();
		}
	}
	
	// berschreiben der Methode paint() von Canvas
	public void paint (Graphics g)
	{	
		d = this.getSize();
		w = d.width;
		h = d.height;
		
		// FILL THE BACKGROUND
		g.setColor(Color.LIGHT_GRAY);
		g.fillRect(0, 0, w, h);
		

		g.drawRect(50, 50, 5, 5);
		LinkedList<Ladung> ladungen = a.getLadungen();
	    // hole alle Ladungsobjekte und rufe dessen Zeichnenmethode auf, bergebe dabei das Graphics Object
		Iterator<Ladung> i = ladungen.iterator();
		while(i.hasNext()) {
			Ladung l = (Ladung) i.next();
			l.display(g);
		}
	} 
	
}
