import java.awt.Color;
import java.awt.Graphics;


public class Ladung {
	
	private float colomb;
	private double posX, posY;
	private double tempPosX, tempPosY;
	private Color color;
	private boolean positive;
	private double speedX;
	private double speedY;
	private boolean marked;

	
	//standardwerte 1 gesetzt
	private final double masseP = 1;//Standardmasse, original Proton: 1.672623 * Math.pow(10, -27);
	private final double masseE = 1;//Standardmasse, original Elektron: 9.1093897 * Math.pow(10, -31);
	
	private final int diameter = 24;
	
	public Ladung(float colomb, boolean isPositiv, int posX, int posY) {
		this.colomb = colomb;
		this.posX = posX;
		this.posY = posY;
		this.positive = isPositiv;
		if(this.positive && colomb > 0) {
			setColor(Color.RED);
		}
		else {
			setColor(Color.BLUE);
			if(colomb > 0){
				this.colomb = this.colomb *-1;
			}
		}
	}
	
	public void display(Graphics g) {
		// Methode um die Ladung zu Zeichnen
		g.setColor(getColor());
		g.fillOval((int)posX - diameter/2, (int)posY - diameter/2, diameter, diameter);
		g.setColor(Color.BLACK);
		g.drawString("" + colomb, (int)posX, (int)posY + diameter);
		
	}
	
	public double getTempPosX() {
		return tempPosX;
	}

	public void setTempPosX(double tempPosX) {
		this.tempPosX = tempPosX;
	}

	public double getTempPosY() {
		return tempPosY;
	}

	public void setTempPosY(double tempPosY) {
		this.tempPosY = tempPosY;
	}

	public void overtakePos(){
		posX = tempPosX;
		posY = tempPosY;
	}
	
	public double getMasse() {
		if(positive) return masseP; else return masseE;
	}
	
	public float getColomb() {
		return colomb;
	}

	public void setColomb(float colomb) {
		this.colomb = colomb;
	}

	public double getPosX() {
		return posX;
	}

	public void setPosX(double posX) {
		this.posX = posX;
	}

	public double getPosY() {
		return posY;
	}

	public void setPosY(double posY) {
		this.posY = posY;
	}

	public Color getColor() {
		return color;
	}

	public void setColor(Color color) {
		this.color = color;
	}

	public int getDiameter() {
		return diameter;
	}

	public boolean isPositive() {
		return positive;
	}

	public void setPositive(boolean positive) {
		this.positive = positive;
	}

	public double getSpeedX() {
		return speedX;
	}

	public void setSpeedX(double speedX) {
		this.speedX = speedX;
	}

	public double getSpeedY() {
		return speedY;
	}

	public void setSpeedY(double speedY) {
		this.speedY = speedY;
	}

	public boolean isMarked() {
		return marked;
	}

	public void setMarked(boolean marked) {
		this.marked = marked;
	}

	
}
