import java.util.Iterator;


public class Berechnung implements Runnable {

	private App a;
	
	private final double eNull 	= 8.854188 * Math.pow(10, -12);
	private final double time 	= 1;
	
	public Berechnung(App a) {
		this.a = a;
	}
	
	public void run() {
		while(true) {
			
			if(a.isSimulationActive()) {
				
				try {
					Thread.sleep(50);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

				/*
				 * Jede Ladung soll mit jeder Ladung verglichen werden. Dazu werden 2 Iterationen ber alle Ladungen benutzt.
				 */
				Iterator Ladung1It = a.getLadungen().iterator();
				while(Ladung1It.hasNext()) {
					Ladung curL1 = (Ladung) Ladung1It.next();
					Iterator Ladung2It = a.getLadungen().iterator();

					/*
					 * Initialisation der Resultierenden Kraft in X und Y Richtung
					 */
					double forceResX = 0;
					double forceResY = 0;
					
					while(Ladung2It.hasNext()) {
						Ladung curL2 = (Ladung) Ladung2It.next();
						
						if(!curL1.equals(curL2)) { // Die zu prfende Ladung darf nicht mit sich selbst verglichen werden
							
							/*
							 * Auslesen der Distanz zwischen den zwei Ladungen in X und Y Richtung
							 */
							double distanzX = curL2.getPosX() - curL1.getPosX();
							double distanzY = curL2.getPosY() - curL1.getPosY();
							boolean collision= false;
							
							/*
							 * Berechnen der effektiven Distanz
							 */
							double distanzR = Math.sqrt(Math.pow((double)distanzX, 2) + Math.pow((double)distanzY, 2));
							
							/*
							 * Berechnung der Kraft durch die beiden Ladungen und der Distanz
							 */
							double forceR 	= (curL1.getColomb() * curL2.getColomb()) / (4 * Math.PI * eNull * Math.pow(distanzR, 2));
							
							
							/*
							 * berbleibsel des Versuches einer Kollisionserkennung, wird nicht mehr bentigt!
							if(Math.abs(forceR) > Math.abs(maxForce)) {
								System.out.println("COLLISION!");
								a.getLadungen().remove(curL1);
								a.getLadungen().remove(curL2);
								a.getLadungen().add(new Ladung(1,true,(int)curL1.getPosX(),(int)curL1.getPosY()));
								break;
							}
							if ((!curL1.isPositive() || !curL1.isPositive()) && !(!curL1.isPositive() && !curL1.isPositive())) forceR = forceR*-1;
							*/

							/*
							 * Berechnung des Winkels zwischen den Beiden Ladungen (wird spter fr das Rckrechnen der Kraft bentigt)
							 */
							double winkel = Math.toDegrees(Math.atan(distanzY/distanzX));
							
							/*
							 * Verringerung der Kraft fr bessere Simulationsdarstellung
							 */
							double forceX = Math.cos(Math.toRadians(winkel)) * forceR/40000;
							double forceY = Math.sin(Math.toRadians(winkel)) * forceR/40000;

							/*
							 * (1) Je nach Position der beiden Ladungen zueinander im Koordinatensystem muss die Kraft umgekehrt werden.
							 */
							if ((distanzX > 0 && forceX > 0)) forceX = forceX*-1;
							if (((distanzY > 0 && forceY > 0) || (distanzY < 0 && forceY < 0)))  forceY = forceY*-1;
							
							/*
							 * Falls die Ladungen extrem nahe beieinander Ligen werden die Krfte unendlich gross.
							 * Um dies zu verhindert wird die Kraft in diesem Fall neu gesetzt.
							 */
							if(Math.sqrt(Math.pow(curL1.getPosX()-curL2.getPosX(), 2) + Math.pow(curL1.getPosY()-curL2.getPosY(), 2)) < (curL1.getDiameter()/2)+(curL2.getDiameter()/2)) {
								
								/*
								 * Neuer Abstand und neue Kraft anhand der Radien der Ladungen
								 */
								distanzR = (curL1.getDiameter()/2)+(curL2.getDiameter()/2);
								
								forceR = (curL1.getColomb() * curL2.getColomb()) / (4 * Math.PI * eNull * Math.pow(distanzR, 2));
								forceX = Math.cos(Math.toRadians(winkel)) * forceR/40000;
								forceY = Math.sin(Math.toRadians(winkel)) * forceR/40000;
								
								collision = true;
							}

							/*
							 * (2) Je nach Position der beiden Ladungen zueinander im Koordinatensystem muss die Kraft umgekehrt werden.
							 */
							if ((!curL1.isPositive() || !curL2.isPositive()) && !(!curL1.isPositive() && !curL2.isPositive()) && (!curL1.isPositive())) {
								if(distanzX < 0)forceX = forceX*-1;
							}
							if(distanzX < 0 && curL1.isPositive() && !curL2.isPositive()){
								forceX = forceX*-1;
							}
							if (forceR < 0) {
								forceX = forceX*-1;
								forceY = forceY*-1;
							}							
							
							/*
							 * Addieren der Kraft, die von allen Ladungen ausgehen in eine Resultierende Kraft fr die aktuelle Ladung.
							 */
							forceResX += forceX;
							forceResY += forceY;
							
							/*
							 * berbleibsel des Versuches einer Kollisionserkennung, wird nicht mehr bentigt!
							if(collision){
								
								curL1.setSpeedX(curL1.getSpeedX() *-1);
								curL1.setSpeedY(curL1.getSpeedY() *-1);	
								
								forceResX = forceResX*-1;
								forceResY = forceResY*-1;
								
								//evt. Kollision abfangen -> keine punktladungen
							}
							*/
						}
					}
					
					/*
					 * Berechnung der Beschleunigung
					 * Da wir m = 1 Haben ist die force als acceleration anzusehen!
					 */
					double accelerationX = forceResX / curL1.getMasse();
					double accelerationY = forceResY / curL1.getMasse();
					
					/*
					 * Berechnung der Geschwindigkeit
					 * Annahme von t = 1
					 */
					double speedX = curL1.getSpeedX() + accelerationX * time;
					double speedY = curL1.getSpeedY() + accelerationY * time;

					/*
					 * Setzen der berechneten Geschwindikeit fr die aktuelle Ladung (wird als vNull (Anfangsgeschwindigkeit) gebraucht)
					 */
					curL1.setSpeedX(speedX);
					curL1.setSpeedY(speedY);

					/*
					 * Berechnung der neuen Positionen (X und Y).
					 * Faktor durch 1000 eingefgt fr langsamere Simulationsdarstellung
					 */
					// 
					double posNewX = curL1.getPosX() + speedX * a.getSimulationSpeed()/1000 * time;
					double posNewY = curL1.getPosY() + speedY * a.getSimulationSpeed()/1000 * time;

					/*
					 * Setzen der berechneten Positionen fr die aktuelle Ladung in einer Temporren Variable
					 * Dies verhindert, dass die noch zu berechnenden Ladungen durch neue Positionsangaben verflscht werden.
					 */
					curL1.setTempPosX(posNewX);
					curL1.setTempPosY(posNewY);
					
					
				}
				
				/*
				 * berschreiben der Positionsangaben durch die von der berechnung neu gesetzten temporren Werte.
				 */
				Iterator LadungIt = a.getLadungen().iterator();
				while(LadungIt.hasNext()) {
					Ladung ldg = (Ladung) LadungIt.next();
					ldg.overtakePos();
				}
				
				/*
				 * Zeichnen der Simmulationsflche
				 */
				a.mc.repaint();
				
				/*
				 * berbleibsel des Versuches einer Kollisionserkennung, wird nicht mehr bentigt!
				double ccDistanzX, ccDistanzY, ccDistanzR, ccDistanzReal, ccDistanzMissing, ccWinkel, ccAddToX, ccAddToY;
				String isPos1, isPos2;
				
				Iterator lcc1 = a.getLadungen().iterator();
				while(lcc1.hasNext()) {
					Ladung lccCur1 = (Ladung) lcc1.next();
					Iterator lcc2 = a.getLadungen().iterator();
					while(lcc2.hasNext()) {
						Ladung lccCur2 = (Ladung) lcc2.next();	
						
						if(!lccCur1.equals(lccCur2) && !lccCur1.isMarked()) {
						
							ccDistanzX = lccCur1.getPosX() - lccCur2.getPosX();
							ccDistanzY = lccCur1.getPosY() - lccCur2.getPosY();
							ccDistanzR = Math.sqrt(Math.pow(ccDistanzX, 2) + Math.pow(ccDistanzY, 2));
							ccDistanzReal = (lccCur1.getDiameter()/2)+(lccCur2.getDiameter()/2);
							
							System.out.println("COL INFO! " + lccCur1.getPosX() + "-" + lccCur2.getPosX() + " -> " + ccDistanzX + " - " + ccDistanzY + " - " + ccDistanzReal);
							
							if(ccDistanzR <= ccDistanzReal) {
								// spter im verhltnis zur geschwindigkeit, jetzt noch 50:50
								ccDistanzMissing = (ccDistanzReal - ccDistanzR) / 2;
								ccWinkel = Math.toDegrees(Math.atan(ccDistanzY/ccDistanzX));
								ccAddToX = Math.cos(Math.toRadians(ccWinkel)) * ccDistanzMissing;
								ccAddToY = Math.sin(Math.toRadians(ccWinkel)) * ccDistanzMissing;

								if(lccCur1.isPositive()) isPos1 = "P"; else isPos1 = "N";
								if(lccCur2.isPositive()) isPos2 = "P"; else isPos2 = "N";
								
								if(ccWinkel > 0 && ccWinkel < 180) {
									lccCur1.setPosX(lccCur1.getPosX() + ccAddToX);
									lccCur2.setPosX(lccCur2.getPosX() - ccAddToX);
									System.out.println("SET NEW L1"+isPos1+" + X | L2"+isPos2+" - X");
								}
								else {
									lccCur1.setPosX(lccCur1.getPosX() - ccAddToX);
									lccCur2.setPosX(lccCur2.getPosX() + ccAddToX);
									System.out.println("SET NEW L1"+isPos1+" - X | L2"+isPos2+" + X");
								}
								
								if(((ccWinkel > 0 && ccWinkel < 90) || (ccWinkel > 270 && ccWinkel < 360))) {
									lccCur1.setPosY(lccCur1.getPosY() + ccAddToY);
									lccCur2.setPosY(lccCur2.getPosY() - ccAddToY);
									System.out.println("SET NEW L1"+isPos1+" + Y | L2"+isPos2+" - Y");
								}
								else {
									lccCur1.setPosY(lccCur1.getPosY() - ccAddToY);
									lccCur2.setPosY(lccCur2.getPosY() + ccAddToY);
									System.out.println("SET NEW L1"+isPos1+" - Y | L2"+isPos2+" + Y");
								}

								lccCur1.setSpeedX(0);
								lccCur1.setSpeedY(0);
								lccCur2.setSpeedX(0);
								lccCur2.setSpeedY(0);
								
								System.out.println("COL DETECTED! " + ccWinkel + " - " + ccDistanzMissing + " - " + ccAddToX + " - " + ccAddToY);
							}
						}
						lccCur1.setMarked(true);
					}
				}
				ENDE 
				*/
				
			}
			else {
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	}
}