import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.LinkedList;



public class App extends Applet implements ActionListener, FocusListener, AdjustmentListener {

	boolean isPositiv = true;
    boolean simulationActive = false;
    int simulationSpeed = 15;

    MyCanvas mc;
    Thread mcThread;

    LinkedList<Ladung> ladungen = new LinkedList<Ladung>();
      
    TextField colombTF;
    Button start, stop, addLadung, reset, gen, genPos, genNeg;
    Scrollbar timeInterval;
    CheckboxGroup vorzeichen;
    Checkbox positiv, negativ;
    Label hilfeText;


    public void init() {
    	setLayout(new BorderLayout());
            
        Thread calcThread = new Thread(new Berechnung(this));
        calcThread.start();
           
        fillWest();
        fillCenter();
            
        this.setSize(1000, 800);
    }

    private void fillWest() {
    	mc = new MyCanvas(this);
    	mc.setVisible(true);
    	mc.setSize(800, 800);
    	mc.setApp(this);
    	add(mc, BorderLayout.WEST);
    }

    private void fillCenter() {
    	Panel p = new Panel();
    	p.setLayout(new GridLayout(30,1));
    	  
    	colombTF = new TextField(2);
    	colombTF.setText("1");
    	p.add(colombTF);
    	  
    	vorzeichen = new CheckboxGroup();
    	positiv = new Checkbox("Positiv", vorzeichen, true);
    	negativ = new Checkbox("Negativ", vorzeichen, false);
    	positiv.addFocusListener(this);
    	negativ.addFocusListener(this);
    	p.add(positiv);
    	p.add(negativ);
    	  
    	start = new Button("Start");
    	start.addActionListener(this);
    	stop = new Button("Stop");
    	stop.addActionListener(this);
    	reset = new Button("Reset");
    	reset.addActionListener(this);
    	timeInterval = new Scrollbar(Scrollbar.HORIZONTAL, simulationSpeed, 1, 1, 30);
    	timeInterval.addAdjustmentListener(this);
    	p.add(start);
    	p.add(stop);
    	p.add(reset);
    	p.add(timeInterval);
          
    	gen = new Button("Gen");
    	gen.addActionListener(this);
    	genPos = new Button("Gen Pos");
    	genPos.addActionListener(this);
    	genNeg = new Button("Gen Neg");
    	genNeg.addActionListener(this);
    	p.add(gen);
    	p.add(genPos);
    	p.add(genNeg);
          
    	p.setSize(200, 800);
    	add(p, BorderLayout.CENTER);
    }

    public void paint(Graphics g) {
    	mc.paint(g);
    }

    public LinkedList<Ladung> getLadungen() {
    	return ladungen;
    }

    private void generateRandoms(int count, int art) {
    	if(count > 1000) count = 20;
    	int canvasSizeX = mc.getWidth();
    	int canvasSizeY = mc.getHeight();
    	int canvasSizeXToTake, canvasSizeYToTake;
    	int ladungsWert = getColoumbValue();
    	boolean posOrNeg;
            
    	for(int i=0;i<count;i++) {
    		canvasSizeXToTake = (int) (Math.random() * canvasSizeX);
    		canvasSizeYToTake = (int) (Math.random() * canvasSizeY);
                  
    		if(art == 0) {
    			posOrNeg = (Math.random() > 0.5) ? true : false;
    			Ladung l = new Ladung(ladungsWert, posOrNeg, canvasSizeXToTake, canvasSizeYToTake);
    			ladungen.add(l);
    		}
    		else if(art < 0) {
    			posOrNeg = false;
    			Ladung l = new Ladung(ladungsWert, posOrNeg, canvasSizeXToTake, canvasSizeYToTake);
    			ladungen.add(l);
    		}
    		else if (art > 0) {
    			posOrNeg = true;
    			Ladung l = new Ladung(ladungsWert, posOrNeg, canvasSizeXToTake, canvasSizeYToTake);
    			ladungen.add(l);
    		}
    	}
            
    	mc.repaint();
      }
      
      // Action Event Handlers
      public synchronized void actionPerformed(ActionEvent e) {
    	  Object s = e.getSource();
    	  if(s == reset) {
    		  while(!ladungen.isEmpty()) {
    			  ladungen.remove();           
    		  }
    		  simulationActive = false;
    		  mc.repaint();
    	  }
    	  if(s == start) {
    		  simulationActive = true;
    		  mc.repaint();
    	  }
    	  if(s == stop) {
    		  simulationActive = false;    
    		  mc.repaint();           
    	  }
    	  if(s == gen) {
    		  generateRandoms(20,0);
    	  }
    	  if(s == genPos) {
    		  generateRandoms(20,1);
    	  }
    	  if(s == genNeg) {
    		  generateRandoms(20,-1);
    	  }
      }
      
      public void focusLost(FocusEvent e) { }
      public void focusGained(FocusEvent e) {
    	  Object s = e.getSource();
    	  if(s == positiv) {
    		  isPositiv = true;
    	  }
    	  if(s == negativ) {
    		  isPositiv = false;
    	  }
      }
      
      public void adjustmentValueChanged(AdjustmentEvent e) {
    	  Object s = e.getSource();
    	  if(s == timeInterval) {
    		  simulationSpeed = (int) (timeInterval.getValue());
    		  System.out.println("SIM SPEED: " + simulationSpeed);
    	  }
      }
    
    public int getColoumbValue() {
    	return Integer.parseInt(colombTF.getText());
    }

	public boolean isPositiv() {
		return isPositiv;
	}

	public void setPositiv(boolean isPositiv) {
		this.isPositiv = isPositiv;
	}

	public boolean isSimulationActive() {
		return simulationActive;
	}

	public void setSimulationActive(boolean simulationActive) {
		this.simulationActive = simulationActive;
	}

	public int getSimulationSpeed() {
		return simulationSpeed;
	}

	public void setSimulationSpeed(int simulationSpeed) {
		this.simulationSpeed = simulationSpeed;
	}

	public MyCanvas getMc() {
		return mc;
	}

	public void setMc(MyCanvas mc) {
		this.mc = mc;
	}

	public Thread getMcThread() {
		return mcThread;
	}

	public void setMcThread(Thread mcThread) {
		this.mcThread = mcThread;
	}

	public TextField getColombTF() {
		return colombTF;
	}

	public void setColombTF(TextField colombTF) {
		this.colombTF = colombTF;
	}

	public Button getStart() {
		return start;
	}

	public void setStart(Button start) {
		this.start = start;
	}

	public Button getStop() {
		return stop;
	}

	public void setStop(Button stop) {
		this.stop = stop;
	}

	public Button getAddLadung() {
		return addLadung;
	}

	public void setAddLadung(Button addLadung) {
		this.addLadung = addLadung;
	}

	public Button getReset() {
		return reset;
	}

	public void setReset(Button reset) {
		this.reset = reset;
	}

	public Button getGen() {
		return gen;
	}

	public void setGen(Button gen) {
		this.gen = gen;
	}

	public Button getGenPos() {
		return genPos;
	}

	public void setGenPos(Button genPos) {
		this.genPos = genPos;
	}

	public Button getGenNeg() {
		return genNeg;
	}

	public void setGenNeg(Button genNeg) {
		this.genNeg = genNeg;
	}

	public Scrollbar getTimeInterval() {
		return timeInterval;
	}

	public void setTimeInterval(Scrollbar timeInterval) {
		this.timeInterval = timeInterval;
	}

	public CheckboxGroup getVorzeichen() {
		return vorzeichen;
	}

	public void setVorzeichen(CheckboxGroup vorzeichen) {
		this.vorzeichen = vorzeichen;
	}

	public Checkbox getPositiv() {
		return positiv;
	}

	public void setPositiv(Checkbox positiv) {
		this.positiv = positiv;
	}

	public Checkbox getNegativ() {
		return negativ;
	}

	public void setNegativ(Checkbox negativ) {
		this.negativ = negativ;
	}

	public void setLadungen(LinkedList<Ladung> ladungen) {
		this.ladungen = ladungen;
	}

      
}
